import type { Protocol } from 'devtools-protocol';
import type { ICdpClient } from '../../../cdp/CdpClient.js';
import { Deferred } from '../../../utils/Deferred.js';
import type { Result } from '../../../utils/result.js';
import type { EventManager } from '../events/EventManager.js';
import type { NetworkStorage } from '../network/NetworkStorage.js';
import type { ChannelProxy } from '../script/ChannelProxy.js';
import type { PreloadScriptStorage } from '../script/PreloadScriptStorage.js';
import type { RealmStorage } from '../script/RealmStorage.js';
export declare class CdpTarget {
    #private;
    static create(targetId: Protocol.Target.TargetID, cdpClient: ICdpClient, browserCdpClient: ICdpClient, cdpSessionId: Protocol.Target.SessionID, realmStorage: RealmStorage, eventManager: EventManager, preloadScriptStorage: PreloadScriptStorage, networkStorage: NetworkStorage, acceptInsecureCerts: boolean): CdpTarget;
    constructor(targetId: Protocol.Target.TargetID, cdpClient: ICdpClient, browserCdpClient: ICdpClient, cdpSessionId: Protocol.Target.SessionID, eventManager: EventManager, preloadScriptStorage: PreloadScriptStorage, networkStorage: NetworkStorage, acceptInsecureCerts: boolean);
    /** Returns a promise that resolves when the target is unblocked. */
    get targetUnblocked(): Deferred<Result<void>>;
    get targetId(): Protocol.Target.TargetID;
    get cdpClient(): ICdpClient;
    get browserCdpClient(): ICdpClient;
    /** Needed for CDP escape path. */
    get cdpSessionId(): Protocol.Target.SessionID;
    /** Calls `Fetch.enable` with the added network intercepts. */
    fetchEnable(): Promise<void>;
    /** Calls `Fetch.disable`. */
    fetchDisable(): Promise<void>;
    /**
     * All the ProxyChannels from all the preload scripts of the given
     * BrowsingContext.
     */
    getChannels(): ChannelProxy[];
}
