const express = require('express'); // Adding Express
const puppeteer = require('puppeteer'); // Adding Puppeteer
const fs = require('fs');
const util = require('util');

const app = express(); // Initializing Express
const log_file = fs.createWriteStream(__dirname + '/debug.log', { flags : 'a' });
const log_stdout = process.stdout;

console.log = function(d) { //
  log_file.write(util.format(d) + '\n');
  log_stdout.write(util.format(d) + '\n');
};

// Adding simple GET request route as a test
app.get('/new16', async function(req, res) {
  var start = req.query.s || (new Date().getTime());
  var q = req.query.q || '';
  try {
    console.log(start + ': ' + q + ': ---start');
    const browser = await puppeteer.launch({
      headless: true,
      args: ['--single-process', '--no-zygote', '--no-sandbox', '--disable-setuid-sandbox'],
    });
    console.log(start + ': ' + q + ': launched' + ' (+' + (((new Date().getTime()) - start)/1000) + ')');
    const page = await browser.newPage();
    console.log(start + ': ' + q + ': tab' + ' (+' + (((new Date().getTime()) - start)/1000) + ')');
    //await page.setViewport({ width: 1280, height: 1720 });
    await page.goto('https://ekinobilet.fond-kino.ru/films/', { waitUntil: 'networkidle2' });
    //await page.waitForNavigation();
    console.log(start + ': ' + q + ': loaded' + ' (+' + (((new Date().getTime()) - start)/1000) + ')');

 
    // Type username
    await page.waitForSelector('.widget-box [name="query"]');
    await page.type('.widget-box [name="query"]', q);

    console.log(start + ': ' + q + ': typed' + ' (+' + (((new Date().getTime()) - start)/1000) + ')');

    await page.waitForSelector('.widget-box .-ico-search')
    await page.click('.widget-box .-ico-search')

    console.log(start + ': ' + q + ': search' + ' (+' + (((new Date().getTime()) - start)/1000) + ')');


    //await page.waitForSelector('#newElementThatAppeared');
    //await page.keyboard.press('Enter');
    await page.waitForNavigation();

    console.log(start + ': ' + q + ': found---' + ' (+' + (((new Date().getTime()) - start)/1000) + ')');
    /*
    // Capture screenshot
    await page.screenshot({
      path: 'screenshot.jpg',
    });
    */
    //const articles = await page.$$('article');
    //let send = [String(articles.length)];
    /*
    let articles = await page.$$eval('article', elements => {
      return elements.map(element => element.innerHTML); 
    });
    */

    let films = await page.$eval('#films', element => element.outerHTML);
    await browser.close();

    res.set('Content-Type', 'text/html');
    res.write(films);
    res.end('');

  } catch (error) {
    res.status(500).send(error.toString());
  }


});

// Making Express listen on port 7000
app.listen(7000, function() {
  //console.log('Running on port 7000.');
});
